; TeddyWareZ MSX Z80 source file.
;
; Prog: Boot Sector for SCC Blaffer NT.
; Code: d-fader^TwZ.
; Date: August 19, 1999
;
; cmnt: none.
;             
; coded in Chaos Assembler 2.0
;
; (C) 1999 TeddyWareZ!

#include "macro's.asm"

	.org $c000 - 7

	.db $fe
	.dw start_program,end_program,start_code

BootAdr:			.equ $d300



start_program:
	.db $eb,$fe,$90  		; type disk...

	.text "Blaffer!"		; Name disk

	.dw 512			; Number of bytes per sector
	.db 2				; Number of sectors per cluster
	.db 1,0			; Reserved sectors
	.db 2				; Number of File Allocation Tables (FAT's)
	.dw 112			; Maximum number of files in directory
	.dw 1440			; Number of sectors on disk
	.db $f9			; Media descriptor
	.dw 3				; Number of sectors per FAT
	.dw 9				; Number of sectors per track
	.dw 2				; Number of sides on disk (1=single, 2=double)
	.dw 0				; Hidden sectors.

	ret nc			; Must be RET NC (on every disk!!)

	jp StartBoot

	.db "              "
	.db " SCC BLAFFER NT "
	.db "                "
	.db "    (C) 1999    "
	.db "   TeddyWareZ   "
	.db "                "

StartBoot:
	ld sp,$f51f

	di 

	ld a,($fcc1)
	ld h,0
	call enaslt

	ld de,fcb
	bdos(open)

	ld de,BootAdr
	bdos(set_dma)

	ld hl,1
	ld (rec_size),hl

	ld hl,(file_size)
	ld de,fcb
	bdos(rnd_br)

	jp BootAdr					; start code!

Fcb:
	.db    0
BlafFilename:
	.db    "BLAF_NT 020"
clear_fcb:
	.db    0,0
rec_size:
	.db    0,0
file_size:
	.db    0,0,0,0,0,0,0,0

	.db    0,0,0,0,0,0,0,0

	.db    0,0,0,0
	.db    0


	.org $c100

start_code:
	xor a
	call cls

	SetVram(0,0,write)
	ld hl,text
	ld b,end_text-text
	ld c,$98
	otir

	call kilbuf
	call chget

	ld de,start_program
	bdos(26)

	ld de,0
	ld h,1
	ld l,0
	bdos(48)

	ret
text:
	.text "Put disk in drive A: and slam [any] key when ready..."
end_text:

end_program:

.end
